'  Quick-and-dirty routine written to compare two files. The assumption is
'  that they are files known to be different from one another, already. I
'  want to know HOW different they are from one another. Essentially, this
'  program just reads two files, notes the number of bytes read, and notes
'  how many bytes do not match. (This is a strict byte-for-byte comparison.)
'  Written by Ward Shrake
'  Last update: January 20, 1999
' print some lines of text on the screen, as a title screen
PRINT
PRINT"  HowDif 1.0 by Ward Shrake"
PRINT"  (A byte-for-byte comparison tool)"
PRINT

' get input and output files from user
INPUT"Name of first file  "; filename1$
INPUT"Name of second file "; filename2$
IF filename1$ = "" or filename2$ = "" THEN STOP

OPEN filename1$ FOR BINARY AS #1
OPEN filename2$ FOR BINARY AS #2

' initialize variables
br=-1   ' byte position within the file, starting at zero on first increment
bw=0    ' number of total mismatches found
ba=0    ' address of byte we are working on now
bl=0    ' address of last mismatch found
bs=0    ' flag used to show if there are a series of mismatches


WHILE NOT EOF(1)        ' do this loop as long as the file has not ended
  br=br+1               ' increment the counter showing how many bytes read
  GET$ 1, 1, A$         ' read one byte from each of the two input files
  GET$ 2, 1, B$
  IF a$=b$ THEN         ' compare the two single bytes we just read in
    ' the two bytes matched. see if this match ended a series of mismatches?
    WHILE bs                            ' if flag is set, indicating a series
      PRINT"    through byte "br-1      ' show the last mismatch found
      bs=0                              ' then reset the flag for next time
    WEND
  ELSE
    ' the two bytes failed to match.
    bw=bw+1             ' add one to the counter showing # of mismatches
    bl=ba               ' what was the address of the last mismatch?
    ba=br               ' keep track of the address this error happened at
    IF bl=ba-1 THEN     ' if one byte ago was also an error...
      bs=1              ' then set the flag showing we have a series going
    ELSE
      PRINT"Mismatch at byte "br
    END IF
  END IF
WEND


' when the program is all done comparing, print a summary report onscreen
PRINT
PRINT"Total bytes read "br
PRINT"Mismatches found "bw
PRINT


CLOSE #1        ' close the files we were comparing
CLOSE #2
STOP            ' end of the program. go back to DOS
